/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Hashtable;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.task.TimeServerNode;

public class TimeServer {
    private String m_serverID;
    private Hashtable<String, TimeServerNode> m_nodeTable;

    public TimeServer(String serverID) {
        this.m_serverID = serverID;
        this.m_nodeTable = new Hashtable();
    }

    public Hashtable<String, TimeServerNode> getNodeTable() {
        return this.m_nodeTable;
    }

    public String[] getNodeList() {
        String[] s = new String[this.m_nodeTable.size()];
        return this.m_nodeTable.keySet().toArray(s);
    }

    public void addToNodeTable(String node, String tsLine) {
        TimeServerNode tsn = new TimeServerNode(node);
        boolean ret = tsn.addDataToNode(tsLine);
        if (ret) {
            if (this.m_nodeTable.get(node) != null) {
                this.m_nodeTable.remove(node);
            }
            this.m_nodeTable.put(node, tsn);
        } else if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("Failed to add entry >" + tsLine + "< into nodetable for node " + node));
        }
    }
}

